"use strict";(globalThis.webpackChunk_plex_client_qt=globalThis.webpackChunk_plex_client_qt||[]).push([["packages_visualizer_shaders_spotlights_glsl"],{3171:n=>{n.exports="// https://www.shadertoy.com/view/MdsXWM\n#define BEATMOVE 1\n\nprecision mediump float;\n\nuniform float uTime;\nuniform vec2 uResolution;\nvarying vec2 vTextureCoord;\nvarying vec4 vColor;\nuniform sampler2D uSampler;\n\nconst float dots = 20.; //number of lights\nconst float radius = .25; //radius of light ring\nconst float brightness = 0.02;\n\n#define PI 3.14\n\n//convert HSV to RGB\nvec3 hsv2rgb(vec3 c){\n  vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\n  vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\n  return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\n\nvoid main( void ) {\n\n  vec2 p=(gl_FragCoord.xy-.5*uResolution.xy)/min(uResolution.x,uResolution.y);\n  vec3 c=vec3(0,0,0.1); //background color\n\n  for(float i=0.;i<dots; i++){\n    //read frequency for this dot from audio input channel\n    //based on its index in the circle\n    float vol = texture2D(uSampler, vec2(i/dots, 0.0)).x;\n    float b = vol * brightness;\n\n    //get location of dot\n    float angle = (PI/2.)+2.*PI*i/dots;\n    float x = radius*cos(angle);\n    float y = radius*sin(angle);\n    vec2 o = vec2(x,y);\n\n    //get color of dot based on its index in the\n    //circle + time to rotate colors\n    vec3 dotCol = hsv2rgb(vec3((i + uTime*10.)/dots,1.,1.0));\n\n    //get brightness of this pixel based on distance to dot\n    c += b/(length(p-o))*dotCol;\n  }\n\n  gl_FragColor = vec4(c,1);\n}\n"}}]);